/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.Diskette;
import com.ibm.hwmca.fw.mediasvc.InvalidFileSystemException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceProperties;
import com.ibm.hwmca.fw.mediasvc.MediaProperties;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameterKeys;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameters;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.mediasvc.USBFlashDrive;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public abstract class MediaDevice
implements MediaServicesErrorIds,
MediaServicesParameterKeys {
    static final String TRACE_MASKT = "XMDADEVT";
    static final String TRACE_MASKF = "XMDADEVF";
    static final String TRACE_MASKD = "XMDADEVD";
    public static final int FILESYSTEM_VFAT = 1;
    public static final int FILESYSTEM_UDF = 2;
    public static final int FILESYSTEM_ISO9660 = 3;
    public static final int FILESYSTEM_EXT2 = 4;
    public static final int FILESYSTEM_EXT3 = 5;
    public static final String VFAT = "vfat";
    public static final String UDF = "udf";
    public static final String ISO9660 = "iso9660";
    public static final String EXT2 = "ext2";
    public static final String EXT3 = "ext3";
    public static final String MSDOS = "msdos";
    private static final String[] MOUNT_SCRIPT_MESSAGES = new String[]{"Successful mount in read-write mode...", "Error mounting, cause unknown...", "Could not unmount already mounted media...", "Successful mount in read-only mode...", "Error mounting, apparently due to hardware failure...", "Error mounting, media not inserted...", "Error mounting, unrecognized filesystem...possibly unformatted media", "Error attempting to mount read-only media in read-write mode..."};
    private static final String UNMOUNTSCRIPT = "media.unmount.script";
    private static final String MOUNTSCRIPT = "media.mount.script";
    private static final String WHO_AM_I_COMMAND = "whoami";
    private static final String OUTPUT_FILE_SUFFIX = "_output";
    private static final String DVD_WRITE_CHECK_FILE = "writecheck";
    private static final String DVD_WRITE_TEST_STRING = "Can we write to the dvd?";
    static final String EJECTSCRIPT = "media.eject.script";
    static final String CHECKMEDIASCRIPT = "media.device.check.media.script";
    static final String LOCKDOORCOMMAND = "media.device.lockdoor";
    static final String UNLOCKDOORCOMMAND = "media.device.unlockdoor";
    static final String LOCKSCRIPT = "media.device.lock.script";
    static final String DISKETTEFORMATSCRIPT = "media.disketteformat.script";
    static final String DVDFORMATSCRIPT = "media.dvdformat.script";
    static final String USBMEMFORMATSCRIPT = "media.usbmemformat.script";
    private boolean readOnly;
    boolean mountWithUid = false;
    boolean driveDoorLocked;
    private boolean isMounted;
    MediaServicesParameters mediaServicesParameters;
    MediaDeviceIdentifier mediaDeviceIdentifier;
    MediaProperties mediaProperties;
    MediaDeviceProperties mediaDeviceProperties;

    MediaDevice(MediaDeviceIdentifier id) {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.MediaDevice(MediaDeviceIdentifier = " + id + ")");
        this.mediaDeviceIdentifier = id;
        this.mediaDeviceProperties = id.getMediaDeviceProperties();
        this.mediaServicesParameters = MediaServicesParameters.getMediaServicesParameters();
        this.mediaProperties = new MediaProperties(this.mediaDeviceProperties);
        this.driveDoorLocked = false;
        Trace.trace(TRACE_MASKT, "<- MediaDevice.MediaDevice()");
    }

    boolean isLockValid() {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isLockValid()");
        boolean result = false;
        result = this.mediaDeviceProperties != null;
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isLockValid(): returns " + result);
        return result;
    }

    abstract String readLabelFile(String var1) throws IOException;

    abstract boolean isMediaPresent() throws MediaDeviceLockException;

    public abstract void eject() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException;

    public abstract void format(String var1, int var2) throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, IllegalArgumentException, UnsupportedOperationException;

    public abstract String getLabel() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException;

    public boolean isDriveDoorLocked() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isDriveDoorLocked()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isDriveDoorLocked(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.mediaDeviceProperties.isLockable()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isDriveDoorLocked(): The media device is not lockable.");
            Trace.trace(TRACE_MASKT, "<- MediaDevice.isDriveDoorLocked(): returns false");
            return false;
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isDriveDoorLocked(): returns " + this.driveDoorLocked);
        return this.driveDoorLocked;
    }

    public boolean isDriveDoorLockable() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isDriveDoorLockable()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isDriveDoorLockable(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isDriveDoorLockable(): returns " + this.mediaDeviceProperties.isLockable());
        return this.mediaDeviceProperties.isLockable();
    }

    public boolean isEjectable() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isEjectable()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isEjectable(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isEjectable(): returns " + this.mediaDeviceProperties.isEjectable());
        return this.mediaDeviceProperties.isEjectable();
    }

    public boolean isFormattable() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isFormattable()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isFormattable(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isFormattable(): returns " + this.mediaDeviceProperties.isFormattable());
        return this.mediaDeviceProperties.isFormattable();
    }

    public boolean isReadOnly() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isReadOnly()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isReadOnly(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (this.mediaDeviceProperties.isReadOnly()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isReadOnly(): The media device is read only.");
            Trace.trace(TRACE_MASKT, "<- MediaDevice.isReadOnly(): returns true");
            return true;
        }
        if (!this.isMounted()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isReadOnly(): The media is not mounted.");
            throw new MediaDeviceException("cannot determine this on unmounted device");
        }
        if (this.getFileSystemType() == 3) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isReadOnly(): The media has a read only iso9660 filesystem.");
            Trace.trace(TRACE_MASKF, "MediaDevice.isReadOnly(): returns true");
            return true;
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isReadOnly(): returns " + this.readOnly);
        return this.readOnly;
    }

    public int getFileSystemType() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getFileSystemType()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getFileSystemType(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMounted()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getFileSystemType(): The media is not mounted.");
            throw new MediaDeviceException("cannot check file system when device not mounted");
        }
        String fileSystem = this.mediaProperties.getFileSystemType();
        Trace.trace(TRACE_MASKF, "MediaServices.getFileSystemType(): fileSystem = " + fileSystem);
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getFileSystemType()");
        if (fileSystem.equals(UDF)) {
            Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType(): fileSystem equals udf.");
            return 2;
        }
        if (fileSystem.equals(ISO9660)) {
            Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType(): fileSystem equals iso9660.");
            return 3;
        }
        if (fileSystem.equals(EXT2)) {
            Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType(): fileSystem equals ext2.");
            return 4;
        }
        if (fileSystem.equals(EXT3)) {
            Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType(): fileSystem equals ext3.");
            return 5;
        }
        if (fileSystem.equals(VFAT) || fileSystem.equals(MSDOS)) {
            if (fileSystem.equals(VFAT)) {
                Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType():  fileSystem equals vfat.");
                return 1;
            }
            Trace.trace(TRACE_MASKD, "MediaDevice.getFileSystemType(): fileSystem equals msdos.");
            return 1;
        }
        throw new MediaDeviceException("unknown file system");
    }

    public long getTotalSpace() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getTotalSpace()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getTotalSpace(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMounted()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getTotalSpace(): The media is not mounted.");
            throw new MediaDeviceException("cannot determine total amount of space on unmounted device");
        }
        long totalSpace = 1000L * this.mediaProperties.getTotalSpace();
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getTotalSpace(): returns " + totalSpace);
        return totalSpace;
    }

    public long getUsedSpace() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getUsedSpace()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getUsedSpace(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMounted()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getUsedSpace(): The media is not mounted.");
            throw new MediaDeviceException("cannot determine used space on unmounted device");
        }
        long usedSpace = 1000L * this.mediaProperties.getUsedSpace();
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getUsedSpace(): returns " + usedSpace);
        return usedSpace;
    }

    public long getAvailableSpace() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getAvailableSpace()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getAvailableSpace(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMounted()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getAvailableSpace(): The media is not mounted.");
            throw new MediaDeviceException("cannot determine available space on unmounted device");
        }
        long availableSpace = 1000L * this.mediaProperties.getAvailableSpace();
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getAvailableSpace(): returns " + availableSpace);
        return availableSpace;
    }

    public boolean isMounted() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.isMounted()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.isMounted(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isMounted(): returns " + this.isMounted);
        return this.isMounted;
    }

    public File getMountPoint() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.getMountPoint()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.getMountPoint(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getMountPoint()");
        return new File(this.mediaDeviceProperties.getMountPoint() + "/");
    }

    public abstract void lockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException;

    public abstract void unlockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException;

    /*
     * WARNING - void declaration
     */
    private void mount(boolean writable) throws MediaDeviceException, NoMediaPresentException, MediaWriteProtectedException, InvalidFileSystemException {
        int rc;
        int i;
        String[] mountCmd;
        Trace.trace(TRACE_MASKT, "-> MediaDevice.mount(writable = " + writable + ")");
        this.readOnly = false;
        try {
            if (this.mediaDeviceIdentifier.getDeviceType().equals("DD") || this.mediaDeviceIdentifier.getDeviceType().equals("UM")) {
                this.getLabel();
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        if (this instanceof Diskette || this instanceof USBFlashDrive) {
            try {
                mountCmd = new String[]{this.mediaServicesParameters.getParm(MOUNTSCRIPT), this.mediaDeviceProperties.getMountPoint(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaDeviceProperties.getDeviceName() + OUTPUT_FILE_SUFFIX, this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log"), "r"};
                for (i = 0; i < 5; ++i) {
                    Trace.trace(TRACE_MASKF, "mountCmd[" + i + "]: " + mountCmd[i]);
                }
                rc = RootProcess.executeProgram(mountCmd);
                Trace.trace(TRACE_MASKF, "MediaDevice.mount(): rc = " + rc);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
                MediaDeviceException mdexc0 = new MediaDeviceException("we had an exception not covered by normal script return errors: " + exc.getMessage());
                new FrameworkLog(MediaServicesErrorIds._logInfo, 634, mdexc0).log();
                throw mdexc0;
            }
            switch (rc) {
                case 0: {
                    Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[rc]);
                    this.isMounted = true;
                    try {
                        if (this.getFileSystemType() == 1) {
                            this.mountWithUid = true;
                            break;
                        }
                        this.mountWithUid = false;
                    }
                    catch (Exception exc) {}
                    break;
                }
                case 3: {
                    Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[rc]);
                    this.isMounted = true;
                    this.readOnly = true;
                    try {
                        if (this.getFileSystemType() == 1) {
                            this.mountWithUid = true;
                            break;
                        }
                        this.mountWithUid = false;
                    }
                    catch (Exception exc) {}
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[rc]);
                    this.isMounted = false;
                    MediaDeviceException mdexc1 = new MediaDeviceException(MOUNT_SCRIPT_MESSAGES[rc]);
                    Trace.trace(TRACE_MASKF, mdexc1);
                    new FrameworkLog(MediaServicesErrorIds._logInfo, 635, mdexc1).log();
                    throw mdexc1;
                }
                case 5: {
                    Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[rc]);
                    this.isMounted = false;
                    throw new NoMediaPresentException(MOUNT_SCRIPT_MESSAGES[rc]);
                }
                case 6: {
                    Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[rc]);
                    this.isMounted = false;
                    throw new InvalidFileSystemException(MOUNT_SCRIPT_MESSAGES[rc]);
                }
                case 7: {
                    Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[rc]);
                    this.isMounted = false;
                    throw new MediaWriteProtectedException(MOUNT_SCRIPT_MESSAGES[rc]);
                }
                default: {
                    this.isMounted = false;
                    MediaDeviceException mdexc2 = new MediaDeviceException(MOUNT_SCRIPT_MESSAGES[1]);
                    Trace.trace(TRACE_MASKF, mdexc2);
                    new FrameworkLog(MediaServicesErrorIds._logInfo, 636, mdexc2).log();
                    throw mdexc2;
                }
            }
            try {
                this.unmount();
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        this.readOnly = false;
        try {
            mountCmd = new String[8];
            mountCmd[0] = this.mediaServicesParameters.getParm(MOUNTSCRIPT);
            mountCmd[1] = this.mediaDeviceProperties.getMountPoint();
            mountCmd[2] = this.mediaServicesParameters.getParm("media.log.dir") + this.mediaDeviceProperties.getDeviceName() + OUTPUT_FILE_SUFFIX;
            mountCmd[3] = this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log");
            mountCmd[4] = writable ? "w" : "r";
            if (this.mountWithUid) {
                mountCmd[5] = "-o";
                mountCmd[6] = "uid=" + this.getLinuxUser();
            } else {
                mountCmd[5] = " ";
                mountCmd[6] = " ";
            }
            mountCmd[7] = this.getLinuxUser();
            for (i = 0; i < 8; ++i) {
                Trace.trace(TRACE_MASKF, "mountCmd[" + i + "]: " + mountCmd[i]);
            }
            rc = RootProcess.executeProgram(mountCmd);
            Trace.trace(TRACE_MASKF, "MediaDevice.mount(): rc = " + rc);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            MediaDeviceException mdexc3 = new MediaDeviceException("we had an exception not covered by normal script return errors: " + exc.getMessage());
            new FrameworkLog(MediaServicesErrorIds._logInfo, 637, mdexc3).log();
            throw mdexc3;
        }
        switch (rc) {
            case 0: {
                void var2_14;
                Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[var2_14]);
                this.isMounted = true;
                break;
            }
            case 3: {
                void var2_14;
                Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[var2_14]);
                this.isMounted = true;
                this.readOnly = true;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                void var2_14;
                Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[var2_14]);
                this.isMounted = false;
                MediaDeviceException mdexc4 = new MediaDeviceException(MOUNT_SCRIPT_MESSAGES[var2_14]);
                Trace.trace(TRACE_MASKF, mdexc4);
                new FrameworkLog(MediaServicesErrorIds._logInfo, 638, mdexc4).log();
                throw mdexc4;
            }
            case 5: {
                void var2_14;
                Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[var2_14]);
                this.isMounted = false;
                throw new NoMediaPresentException(MOUNT_SCRIPT_MESSAGES[var2_14]);
            }
            case 6: {
                void var2_14;
                Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[var2_14]);
                this.isMounted = false;
                throw new InvalidFileSystemException(MOUNT_SCRIPT_MESSAGES[var2_14]);
            }
            case 7: {
                void var2_14;
                Trace.trace(TRACE_MASKF, "MediaDevice.mount(): " + MOUNT_SCRIPT_MESSAGES[var2_14]);
                this.isMounted = false;
                throw new MediaWriteProtectedException(MOUNT_SCRIPT_MESSAGES[var2_14]);
            }
            default: {
                this.isMounted = false;
                MediaDeviceException mdexc5 = new MediaDeviceException(MOUNT_SCRIPT_MESSAGES[1]);
                Trace.trace(TRACE_MASKF, mdexc5);
                new FrameworkLog(MediaServicesErrorIds._logInfo, 639, mdexc5).log();
                throw mdexc5;
            }
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.mount()");
    }

    public void mountReadOnly() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, InvalidFileSystemException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.mountReadOnly()");
        if (!this.isLockValid()) {
            Trace.trace(TRACE_MASKF, "MediaDevice.mountReadOnly(): The media device lock is not valid.");
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        this.mount(false);
        Trace.trace(TRACE_MASKT, "<- MediaDevice.mountReadOnly()");
    }

    public void mountReadWrite() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, MediaWriteProtectedException, InvalidFileSystemException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.mountReadWrite()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        String deviceType = this.mediaDeviceIdentifier.getDeviceType();
        if (deviceType.equals("CD")) {
            throw new MediaWriteProtectedException("CD-ROM drive, cannot mount in read-write mode");
        }
        if (deviceType.equals("DV") && this.isDvdWriteProtected()) {
            throw new MediaWriteProtectedException("DVD-RAM cartridge is write protected");
        }
        this.mount(true);
        Trace.trace(TRACE_MASKT, "<- MediaDevice.mountReadWrite()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean isDvdWriteProtected() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, MediaWriteProtectedException, InvalidFileSystemException {
        boolean writeProtected;
        File file;
        block14: {
            Trace.trace(TRACE_MASKT, "-> MediaDevice.isDvdWriteProtected()");
            this.mount(true);
            file = null;
            OutputStreamWriter testFile = null;
            file = this.getMountPoint();
            testFile = new FileWriter(file.getAbsolutePath() + "/" + DVD_WRITE_CHECK_FILE);
            testFile.write(DVD_WRITE_TEST_STRING);
            Object var6_3 = null;
            try {
                if (testFile != null) {
                    testFile.close();
                }
                break block14;
            }
            catch (IOException ioexc2) {
                Trace.trace(TRACE_MASKF, ioexc2);
            }
            break block14;
            {
                catch (IOException ioexc) {
                    Trace.trace(TRACE_MASKF, ioexc);
                    Object var6_4 = null;
                    try {
                        if (testFile != null) {
                            testFile.close();
                        }
                        break block14;
                    }
                    catch (IOException ioexc2) {
                        Trace.trace(TRACE_MASKF, ioexc2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (testFile != null) {
                        testFile.close();
                    }
                }
                catch (IOException ioexc2) {
                    Trace.trace(TRACE_MASKF, ioexc2);
                }
                throw throwable;
            }
        }
        if (file != null) {
            file = null;
        }
        this.unmount();
        this.mount(true);
        file = this.getMountPoint();
        File finiTest = new File(file.getAbsolutePath() + "/" + DVD_WRITE_CHECK_FILE);
        if (!finiTest.exists()) {
            writeProtected = true;
        } else {
            writeProtected = false;
            finiTest.delete();
        }
        finiTest = null;
        file = null;
        this.unmount();
        Trace.trace(TRACE_MASKT, "<- MediaDevice.isDvdWriteProtected(): returns " + writeProtected);
        return writeProtected;
    }

    public void unmount() throws MediaDeviceException, MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.unmount()");
        Trace.trace(TRACE_MASKD, "MediaDevice.unmount(): Performing finalization and garbage collection.");
        System.runFinalization();
        System.gc();
        Trace.trace(TRACE_MASKD, "MediaDevice.unmount(): Finished finalization and garbage collection.");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMounted) {
            Trace.trace(TRACE_MASKF, "MediaDevice.unmount(): Media Services thinks this media device is not mounted.");
            Trace.trace(TRACE_MASKT, "<- MediaDevice.unmount()");
            return;
        }
        try {
            String[] unmountCmd = new String[]{this.mediaServicesParameters.getParm(UNMOUNTSCRIPT), this.mediaDeviceProperties.getMountPoint(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace(TRACE_MASKF, "MediaDevice.unmount(): unmountCmd[0] = " + unmountCmd[0]);
            Trace.trace(TRACE_MASKF, "MediaDevice.unmount(): unmountCmd[1] = " + unmountCmd[1]);
            Trace.trace(TRACE_MASKF, "MediaDevice.unmount(): unmountCmd[2] = " + unmountCmd[2]);
            int rc = RootProcess.executeProgram(unmountCmd);
            Trace.trace(TRACE_MASKF, "MediaDevice.unmount(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("the unmount operation failed.");
            }
            this.isMounted = false;
        }
        catch (Exception exc) {
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            Trace.trace(TRACE_MASKF, mdexc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 620, mdexc).log();
            throw mdexc;
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.unmount()");
    }

    public synchronized void unlock() throws MediaDeviceLockException {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.unlock()");
        if (this.isLockValid()) {
            try {
                if (this.isMounted()) {
                    Trace.trace(TRACE_MASKF, "MediaDevice.unlock(): The media is currently mounted, unmounting.");
                    this.unmount();
                    Trace.trace(TRACE_MASKF, "MediaDevice.unlock(): The media has been successfully unmounted.");
                }
                Trace.trace(TRACE_MASKF, "MediaDevice.unlock(): Unlocking the " + this.mediaDeviceIdentifier.getDeviceName() + " that is currently locked by " + this.mediaDeviceIdentifier.getCurrentLockOwner() + ".");
                this.mediaDeviceIdentifier.unlock();
                this.mediaDeviceProperties = null;
                Trace.trace(TRACE_MASKF, "MediaDevice.unlock(): The media device was successfully unlocked.");
            }
            catch (Exception exc) {
                this.mediaDeviceIdentifier.unlock();
                this.mediaDeviceProperties = null;
                MediaDeviceLockException mdlexc = new MediaDeviceLockException(exc);
                Trace.trace(TRACE_MASKF, mdlexc);
                new FrameworkLog(MediaServicesErrorIds._logInfo, 621, mdlexc).log();
                throw mdlexc;
            }
        } else {
            Trace.trace(TRACE_MASKF, "MediaDevice.unlock(): The caller does not have a lock on the device and cannot unlock it.");
            return;
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.unlock()");
    }

    protected void finalize() {
        Trace.trace(TRACE_MASKT, "-> MediaDevice.finalize()");
        try {
            this.unlock();
        }
        catch (Exception exc) {
            this.mediaDeviceIdentifier.unlock();
            this.mediaDeviceProperties = null;
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.finalize()");
    }

    /*
     * Loose catch block
     */
    private String getLinuxUser() throws MediaDeviceException {
        String user;
        block9: {
            Trace.trace(TRACE_MASKT, "-> MediaDevice.getLinuxUser()");
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            Process whoProcess = Runtime.getRuntime().exec(WHO_AM_I_COMMAND);
            inputStreamReader = new InputStreamReader(whoProcess.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            user = bufferedReader.readLine();
            Trace.trace(TRACE_MASKF, "MediaDevice.getLinuxUser(): user = " + user);
            Object var6_6 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block9;
            }
            catch (IOException ioexc) {
                Trace.trace(TRACE_MASKF, ioexc);
            }
            break block9;
            {
                catch (IOException ioexc) {
                    Trace.trace(TRACE_MASKF, ioexc);
                    throw new MediaDeviceException(ioexc);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException ioexc) {
                    Trace.trace(TRACE_MASKF, ioexc);
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- MediaDevice.getLinuxUser(): returns " + user);
        return user;
    }
}

